#include "SDL.h"
#include "SDL_image.h"
#include "sprig.h"
#include "SDL_ttf.h"
#include "Libraries/NFont.h"
#include "Libraries/SDL_ColorDef.h"
#include "Libraries/goodio.h"
#include "gameloop.h"
#include "Level.h"

NFont blackFont;

extern SDL_Surface* fireFighterRPic1;
extern SDL_Surface* fireFighterLPic1;
extern SDL_Surface* fireFighterUPic1;
extern SDL_Surface* fireFighterDPic1;
extern SDL_Surface* fireFighterRPic2;
extern SDL_Surface* fireFighterLPic2;
extern SDL_Surface* fireFighterUPic2;
extern SDL_Surface* fireFighterDPic2;

extern SDL_Surface* bonusRPic1;
extern SDL_Surface* bonusRPic2;
extern SDL_Surface* bonusLPic1;
extern SDL_Surface* bonusLPic2;

extern SDL_Surface* housePic1;
extern SDL_Surface* housePic2;
extern SDL_Surface* housePic3;
extern SDL_Surface* housePic4;
extern SDL_Surface* bonusHousePic;

extern SDL_Surface* firePic1;
extern SDL_Surface* firePic2;
extern SDL_Surface* firePic3;

int mx = 0, my = 0;

inline bool mouseAt(int x1, int y1, int x2, int y2)
{
    return (mx >= x1) && (mx <= x2) && (my >= y1) && (my <= y2);
}
inline bool mouseAt(const SDL_Rect& rect)
{
    return (mx >= rect.x) && (mx <= rect.x + rect.w) && (my >= rect.y) && (my <= rect.y + rect.h);
}


int main(int argc, char* argv[])
{
	SDL_Surface* screen = SPG_InitSDL(800, 600, 0, SDL_INIT_VIDEO | SDL_INIT_AUDIO, SDL_SWSURFACE);
    
    SPG_EnableRadians(true);
    //RGB_setSurface(screen);
    srand(time(NULL));
    
    //SI_Reset(false);
    
    
    if(TTF_Init() == -1)
    {
        printf("Unable to initialize SDL_ttf: %s \n", TTF_GetError());
        exit(0);
    }
    
    SDL_Color black = {0, 0, 0, 255};
    SDL_Color white = {255, 255, 255, 255};
    
    int size = 20;
    
    TTF_Font* ttf = TTF_OpenFont("fonts/FreeSans.ttf", size);
    
    if(ttf == NULL)
    {
        printf("Unable to load font: %s \n", TTF_GetError());
        exit(0);
    }
    
    
    blackFont.setDest(screen);
    blackFont.load(ttf, black);
    
    TTF_CloseFont(ttf);
    
    
    SDL_Surface* title = IMG_Load("images/title.png");
    SPG_Draw(title, screen, 0, 0);
    SDL_Flip(screen);
    SDL_Delay(3000);
    SDL_FreeSurface(title);
    
    fireFighterRPic1 = SPG_DisplayFormatAlpha(IMG_Load("images/firefighter-r1.png"));
    fireFighterLPic1 = SPG_DisplayFormatAlpha(IMG_Load("images/firefighter-l1.png"));
    fireFighterUPic1 = SPG_DisplayFormatAlpha(IMG_Load("images/firefighter-u1.png"));
    fireFighterDPic1 = SPG_DisplayFormatAlpha(IMG_Load("images/firefighter-d1.png"));
    fireFighterRPic2 = SPG_DisplayFormatAlpha(IMG_Load("images/firefighter-r2.png"));
    fireFighterLPic2 = SPG_DisplayFormatAlpha(IMG_Load("images/firefighter-l2.png"));
    fireFighterUPic2 = SPG_DisplayFormatAlpha(IMG_Load("images/firefighter-u2.png"));
    fireFighterDPic2 = SPG_DisplayFormatAlpha(IMG_Load("images/firefighter-d2.png"));
    
    bonusRPic1 = SPG_DisplayFormatAlpha(IMG_Load("images/trogdor-r1.png"));
    bonusRPic2 = SPG_DisplayFormatAlpha(IMG_Load("images/trogdor-r2.png"));
    bonusLPic1 = SPG_DisplayFormatAlpha(IMG_Load("images/trogdor-l1.png"));
    bonusLPic2 = SPG_DisplayFormatAlpha(IMG_Load("images/trogdor-l2.png"));
    
    housePic1 = SPG_DisplayFormatAlpha(IMG_Load("images/house1.png"));
    housePic2 = SPG_DisplayFormatAlpha(IMG_Load("images/house2.png"));
    housePic3 = SPG_DisplayFormatAlpha(IMG_Load("images/house3.png"));
    housePic4 = SPG_DisplayFormatAlpha(IMG_Load("images/house4.png"));
    bonusHousePic = SPG_DisplayFormatAlpha(IMG_Load("images/cottage.png"));
    
    firePic1 = SPG_DisplayFormatAlpha(IMG_Load("images/fire1.png"));
    firePic2 = SPG_DisplayFormatAlpha(IMG_Load("images/fire2.png"));
    firePic3 = SPG_DisplayFormatAlpha(IMG_Load("images/fire3.png"));
    
	GameState gameState;
	gameState.screen = screen;
	gameState.player = new Player;
	gameState.grass = SPG_DisplayFormat(SPG_CreateSurface32(SDL_SWSURFACE, screen->w, screen->h));
	SPG_Fill(gameState.grass, RGB_GREEN);
	gameState.burnMap = new BurnMap(screen->w, screen->h);
	gameState.terrainMap = new TerrainMap(screen->w, screen->h);
	
	gameState.loadNextLevel();
	
	GameUpdate gameUpdate;
	
	GameDraw gameDraw;
	
	GameEvent gameEvent;
	
	PL_Set gameSet;
	gameSet.update = &gameUpdate;
	gameSet.draw = &gameDraw;
	gameSet.any = &gameEvent;
	
	PL_Loop(&gameState, gameSet);
	
	if(gameState.won)
	{
	    // Go to victory screen
	    SDL_Surface* s = IMG_Load("images/victory.png");
	    SPG_Draw(s, screen, 0, 0);
	    SDL_Flip(screen);
	    SDL_Delay(3000);
	    SDL_FreeSurface(s);
	}
	else
	{
	    SDL_Surface* s = IMG_Load("images/failure.png");
	    SPG_Draw(s, screen, 0, 0);
	    SDL_Flip(screen);
	    SDL_Delay(3000);
	    SDL_FreeSurface(s);
	}
	
	return 0;
}
